//
//  Using_Different_Types_of_Accessories_in_a_Table_View_CellViewController.m
//  Using Different Types of Accessories in a Table View Cell
//
//  Created by Vandad Nahavandipoor on 29/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Using_Different_Types_of_Accessories_in_a_Table_View_CellViewController.h"

@implementation Using_Different_Types_of_Accessories_in_a_Table_View_CellViewController

@synthesize myTableView;

- (void)                        tableView:(UITableView *)tableView 
 accessoryButtonTappedForRowWithIndexPath:(NSIndexPath *)indexPath{
  
  /* Wykonanie określonego zadania po naciśnięciu przycisku pomocniczego. */
  NSLog(@"Naciśnięto przycisk pomocniczy w komórce o indeksie = %@", indexPath);
  
  UITableViewCell *ownerCell = [tableView cellForRowAtIndexPath:indexPath];
  
  NSLog(@"Tytuł komórki = %@", ownerCell.textLabel.text);
  
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath{
  
  UITableViewCell* result = nil;
  
  if ([tableView isEqual:self.myTableView]){
    
    static NSString *MyCellIdentifier = @"SimpleCell";
    
    /* Próba pobrania istniejącej komórki o podanym identyfikatorze. */
    result = [tableView
              dequeueReusableCellWithIdentifier:MyCellIdentifier];
    
    if (result == nil){
      /* Jeżeli komórka o podanym identyfikatorze nie istnieje, tworzymy nową i używamy jej w widoku tabeli. */
      
      result = [[UITableViewCell alloc]
                initWithStyle:UITableViewCellStyleDefault
                reuseIdentifier:MyCellIdentifier];
    }
    
    result.textLabel.text =
    [NSString stringWithFormat:@"Sekcja %ld, komórka %ld",
     (long)indexPath.section,
     (long)indexPath.row];
    
    result.accessoryType = UITableViewCellAccessoryDetailDisclosureButton;
    
  }
  
  return result;
  
}

- (NSInteger) tableView:(UITableView *)tableView 
  numberOfRowsInSection:(NSInteger)section{
  return 10;
}

- (void)viewDidLoad{
  [super viewDidLoad];
  
  self.myTableView = [[UITableView alloc] initWithFrame:self.view.bounds
                                                  style:UITableViewStylePlain];
  
  self.myTableView.dataSource = self;
  self.myTableView.delegate = self;
  
  self.myTableView.autoresizingMask = 
    UIViewAutoresizingFlexibleWidth |
    UIViewAutoresizingFlexibleHeight;
  
  [self.view addSubview:self.myTableView];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.myTableView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
